// index ubuntu pesan
const express = require('express');
const { Client, LocalAuth } = require('whatsapp-web.js');
const qrcode = require('qrcode-terminal');
const cors = require('cors');
const mysql = require('mysql2'); // Mengimpor mysql2
const app = express(); 

// Middleware CORS
app.use(cors());
app.use(express.json());

// Membuat koneksi pool ke database MySQL
const pool = mysql.createPool({
    host: '46.247.109.23', // Ganti dengan host database Anda
    user: 'admiN',         // Ganti ini dengan username database Anda
    password: 'Jerman123', // Ganti ini dengan password database Anda
    database: 'murid_sekolah',   // Ganti ini dengan nama database Anda
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0
});

// Memeriksa koneksi database
pool.getConnection((err, connection) => {
    if (err) {
        console.error("Koneksi database gagal: ", err);
        return;
    }
    console.log("Koneksi database berhasil!");
    connection.release(); // Kembali ke pool
});

// Inisialisasi client WhatsApp
const client = new Client({
    authStrategy: new LocalAuth(),
    puppeteer: {
        headless: true, // Disarankan untuk server tanpa GUI
        executablePath: '/usr/bin/chromium-browser', // Ganti dengan jalur yang benar jika berbeda
        args: [
            '--no-sandbox',
            '--disable-setuid-sandbox',
            '--disable-dev-shm-usage',
            '--user-data-dir=/tmp/puppeteer'
        ],
    },
});

// Menampilkan QR code di terminal untuk otentikasi
client.on('qr', (qr) => {
    console.log('Scan the QR code above to authenticate.');
    qrcode.generate(qr, { small: true });
});

// Menangani event saat client siap
client.on('ready', () => {
    console.log('WhatsApp bot is ready!');

    const intervalFunc = () => {
        pool.query("SELECT * FROM message WHERE status = '0'", (err, results) => {
            if (err) {
                console.error("Error executing query: ", err);
                return;
            }

            results.forEach((message) => {
                const number = message.number.trim(); // Menghilangkan spasi di awal/akhir

                // Memperbaiki logika penanganan ID chat
                let chatId;
                if (number.startsWith('62')) {
                    chatId = `${number}@c.us`;
                } else if (number.startsWith('0')) {
                    chatId = `+62${number.substring(1)}@c.us`;
                } else {
                    chatId = `+62${number}@c.us`;
                }

                // Ambil data dari kolom database
                const tgl = message.tgl;
                const judul = message.judul;
                const kodeFilTer = message.kodeFilTer;
                const penGirim = message.penGirim;
                const penErima = message.penErima;
                const rekening = message.rekening;
                const kewajiban = message.kewajiban;
                const sisaKewajiban = message.sisaKewajiban;
                const nominal = message.nominal;

                const keterangan = message.keterangan;
                const metodeBayar = message.metodeBayar;

                // Fungsi untuk memformat tanggal ke d-m-Y
function formatTgl(tanggal) {
    const date = new Date(tanggal);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0'); // Bulan 0-11 jadi +1
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
}
// Menyimpan tanggal yang sudah diformat
const fTgl = formatTgl(tgl);
// Fungsi untuk memformat angka dengan separator ribuan
function formatNominal(angka) {
    return angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "."); // Menggunakan . sebagai pemisah ribuan
}
const fNominal = formatNominal(nominal);
const fSisaKewajiban = formatNominal(sisaKewajiban);

// Memperbaiki logika untuk memberikan keterangan pembayaran
// Menentukan keterangan pembayaran
const ketBayar = nominal >= kewajiban ? "Lunas" : "Belum Lunas";

//let ketBayar;
//if (nominal >= kewajiban) {
  //  ketBayar = "Lunas";
//} else {
    //ketBayar = "Belum Lunas";
//}

// Menyiapkan format pesan berdasarkan nilai filTer
let formattedMessage;
if (kodeFilTer === 'Setor') {
    formattedMessage = `
*Tabungan Murid*
      ${penGirim}
Tgl           : ${fTgl}
Nim         : ${rekening}
Nama      : ${penErima}
Setor       : Rp ${fNominal}
Saldo       : Rp ${fSisaKewajiban}
*Terimakasih...*
`;
} else if (kodeFilTer === 'Tarik') {
    formattedMessage = `

*Tabungan Murid*
      ${penGirim}
Tgl           : ${fTgl}
Nim         : ${rekening}
Nama      : ${penErima}
Tarik       : Rp ${fNominal}
Saldo       : Rp ${fSisaKewajiban}
*Terimakasih...*

`;
} else if (kodeFilTer === 'editTab') {
    formattedMessage = `

*Koreksi Tabungan Murid*
      ${penGirim}
Tgl           : ${fTgl}
Nim         : ${rekening}
Nama      : ${penErima}
Setor       : Rp ${fNominal}
Saldo       : Rp ${fSisaKewajiban}
*Terimakasih...*

`;
} else if (kodeFilTer === 'editBayar') {
    formattedMessage = `

*${judul}*
*KOREKSI ${metodeBayar}*
Tgl           : ${fTgl}
Nama      : ${penErima}
Tagihan : Rp ${fNominal}
Bln         : ${rekening}

*Mohon segera dilunasi*
*Terimakasih...*
`;
} else if (kodeFilTer === 'Syahriah') {
    formattedMessage = `

*${judul}*
*${metodeBayar}*
Tgl           : ${fTgl}
Nama      : ${penErima}
Tagihan : Rp ${fNominal}
Bln           : ${rekening}

*Mohon segera dilunasi*
Terimakasih...
`;
} else if (kodeFilTer === 'NonSyahriah') {
    formattedMessage = `

*${judul}*
*${metodeBayar}*
Tgl           : ${fTgl}
Nama      : ${penErima}
Tagihan : Rp ${fNominal}

*Mohon segera dilunasi*
Terimakasih...
`;
} else {
    formattedMessage = `
*${judul}*
Tgl           : ${fTgl}
Nim         : ${rekening}
Nama      : ${penErima}
Bayar       : Rp ${fNominal}
*Terimakasih...*
`;
                }

                console.log(`Persiapan untuk mengirim pesan ke chat ID: ${chatId.trim()}`); // Debugging chatId

                // Kirim pesan
                client.sendMessage(chatId.trim(), formattedMessage)
                    .then(response => {
                        console.log(`Pesan terkirim ke ${chatId}: ${formattedMessage}`);
                        console.log(`ID Pesan: ${response.id}`);

                        // Update pesan status di database
                        pool.query("UPDATE message SET status = '1' WHERE id = ?", [message.id], (err) => {
                            if (err) {
                                console.error("Gagal memperbarui status pesan: ", err);
                            } else {
                                console.log("Status pesan diperbarui menjadi '1' (terkirim)");
                            }
                        });
                    })
                    .catch(err => {
                        console.error("Gagal mengirim pesan ke ", chatId, err);
                        // Perbarui status pesan menjadi gagal
                        pool.query("UPDATE message SET status = '2' WHERE id = ?", [message.id], (err) => {
                            if (err) {
                                console.error("Gagal memperbarui status pesan menjadi '2': ", err);
                            } else {
                                console.log("Status pesan diperbarui menjadi '2' (gagal)");
                            }
                        });
                    });
            });
        });
    };

    // Set interval untuk memeriksa dan mengirim pesan setiap 3 detik
    setInterval(intervalFunc, 3000);
});

// Menjalankan client WhatsApp
client.initialize();

// Menjalankan server Express
const PORT = process.env.PORT || 3001; // Ganti port jika perlu
app.listen(PORT, () => {
    console.log(`Server is running on http://localhost:${PORT}`);
});

